(function(){
  if ( typeof wp === 'undefined' || !wp.blocks ) { return; }

  var registerBlockType = wp.blocks.registerBlockType;
  var __ = wp.i18n.__;
  var createElement = wp.element.createElement;
  var Fragment = wp.element.Fragment;
  var useBlockProps = wp.blockEditor.useBlockProps;
  var RichText = wp.blockEditor.RichText;
  var InspectorControls = wp.blockEditor.InspectorControls;
  var PanelBody = wp.components.PanelBody;
  var Button = wp.components.Button;

  registerBlockType('ticoet/faqgeo', {
    title: 'FAQ GEO',
    icon: 'editor-help',
    category: 'text',
    attributes: {
      questions: { type: 'array', default: [] }
    },

    edit: function(props) {
      var attributes = props.attributes;
      var setAttributes = props.setAttributes;
      var questions = attributes.questions || [];
      var blockProps = useBlockProps();

      function updateQuestion(index, field, value) {
        var copy = questions.slice();
        copy[index] = copy[index] || { question: '', answer: '' };
        copy[index][field] = value;
        setAttributes({ questions: copy });
      }

      function addQuestion() {
        var copy = questions.slice();
        copy.push({ question: 'Nouvelle question', answer: 'Réponse...' });
        setAttributes({ questions: copy });
      }

      function removeQuestion(index) {
        var copy = questions.slice();
        copy.splice(index, 1);
        setAttributes({ questions: copy });
      }

      return createElement(Fragment, null,
        createElement('div', blockProps,
          createElement('div', { className: 'faq-geo-editor' },
            createElement('div', { style: { marginBottom: '10px' } },
              createElement(Button, { isPrimary: true, onClick: addQuestion }, __('➕ Ajouter une question', 'faqgeo'))
            ),
            questions.length === 0 && createElement('p', null, __('Aucune question pour le moment. Cliquez sur "Ajouter une question".', 'faqgeo')),
            questions.map(function(item, idx){
              return createElement('div', { key: idx, style: { border: '1px solid #eee', padding: '10px', marginBottom: '8px', borderRadius: '4px' } },
                createElement(RichText, {
                  tagName: 'h3',
                  value: item.question,
                  onChange: function(val){ updateQuestion(idx, 'question', val); },
                  placeholder: __('Saisir la question...', 'faqgeo')
                }),
                createElement(RichText, {
                  tagName: 'p',
                  value: item.answer,
                  onChange: function(val){ updateQuestion(idx, 'answer', val); },
                  placeholder: __('Saisir la réponse...', 'faqgeo')
                }),
                createElement('div', { style: { marginTop: '6px' } },
                  createElement(Button, { isSecondary: true, onClick: function(){ removeQuestion(idx); } }, __('Supprimer', 'faqgeo'))
                )
              );
            })
          )
        )
      );
    },

    save: function(props) {
      var attributes = props.attributes;
      var questions = attributes.questions || [];
      var blockProps = useBlockProps.save();

      // Build JSON-LD
      var mainEntity = questions.map(function(q){
        return {
          "@type": "Question",
          "name": (q.question || '').replace(/<\/?[^>]+(>|$)/g, ""),
          "acceptedAnswer": {
            "@type": "Answer",
            "text": (q.answer || '').replace(/<\/?[^>]+(>|$)/g, "")
          }
        };
      });

      var schema = {
        "@context": "https://schema.org",
        "@type": "FAQPage",
        "mainEntity": mainEntity
      };

      // Create DOM output: section with details/summary
      var children = [ ];
      questions.forEach(function(q, idx){
        var qText = q.question || '';
        var aText = q.answer || '';
        var details = createElement('details', { key: idx, itemScope: true, itemProp: 'mainEntity', itemType: 'https://schema.org/Question' },
          createElement('summary', { itemProp: 'name' }, createElement('span', { dangerouslySetInnerHTML: { __html: qText } })),
          createElement('div', { itemProp: 'acceptedAnswer', itemScope: true, itemType: 'https://schema.org/Answer' },
            createElement('p', { itemProp: 'text', dangerouslySetInnerHTML: { __html: aText } })
          )
        );
        children.push(details);
      });

      return createElement('section', Object.assign({ className: 'faq-geo' , itemScope: true, itemType: 'https://schema.org/FAQPage' }, blockProps),
        children.concat([ createElement('script', { type: 'application/ld+json' }, JSON.stringify(schema, null, 2)) ])
      );
    }
  });
})();
