<?php
/**
 * Plugin Name: MediaGEO
 * Description: Blocs Gutenberg ImageGEO, VideoGEO et AudioGEO avec JSON-LD automatique + lightbox front.
 * Version: 1.3.0
 * Author: Erwan Tanguy - Ticoët
 * Text Domain: mediageo
 */


if (!defined('ABSPATH')) exit;

define('MEDIAGEO_PATH', plugin_dir_path(__FILE__));
define('MEDIAGEO_URL', plugin_dir_url(__FILE__));

/**
 * Register all blocks using their block.json
 */
function mediageo_register_blocks() {

    $blocks = ['image-geo', 'video-geo', 'audio-geo'];

    foreach ($blocks as $block) {

        register_block_type(
            MEDIAGEO_PATH . "blocks/$block",
            [
                'editor_script' => "mediageo-$block-editor-script",
                'editor_style'  => "mediageo-$block-editor-style",
                'style'         => "mediageo-$block-style",
            ]
        );

        // JS
        wp_register_script(
            "mediageo-$block-editor-script",
            MEDIAGEO_URL . "blocks/$block/index.js",
            ['wp-blocks','wp-element','wp-components','wp-i18n','wp-block-editor'],
            filemtime(MEDIAGEO_PATH . "blocks/$block/index.js")
        );

        // Editor CSS
        wp_register_style(
            "mediageo-$block-editor-style",
            MEDIAGEO_URL . "blocks/$block/editor.css",
            [],
            filemtime(MEDIAGEO_PATH . "blocks/$block/editor.css")
        );

        // Front CSS
        wp_register_style(
            "mediageo-$block-style",
            MEDIAGEO_URL . "blocks/$block/style.css",
            [],
            filemtime(MEDIAGEO_PATH . "blocks/$block/style.css")
        );
    }
}
add_action('init', 'mediageo_register_blocks');


/**
 * Global stylesheet for the plugin
 */
function mediageo_global_styles() {
    wp_enqueue_style(
        'mediageo-global-style',
        MEDIAGEO_URL . 'style.css',
        [],
        filemtime(MEDIAGEO_PATH . 'style.css')
    );
}
add_action('wp_enqueue_scripts', 'mediageo_global_styles');


/**
 * Lightbox (frontend only)
 */
function mediageo_lightbox_script() {
    wp_enqueue_script(
        'mediageo-lightbox',
        MEDIAGEO_URL . 'lightbox.js',
        [],
        filemtime(MEDIAGEO_PATH . 'lightbox.js'),
        true
    );
}
add_action('wp_enqueue_scripts', 'mediageo_lightbox_script');