( function() {
  if ( typeof wp === 'undefined' || !wp.blocks ) return;

  var registerBlockType = wp.blocks.registerBlockType;
  var createElement = wp.element.createElement;
  var Fragment = wp.element.Fragment;
  var useBlockProps = wp.blockEditor.useBlockProps;
  var TextControl = wp.components.TextControl;
  var PanelBody = wp.components.PanelBody;
  var InspectorControls = wp.blockEditor.InspectorControls;
  var SelectControl = wp.components.SelectControl;

  function resolveLicense(licenseType, customUrl) {
    switch (licenseType) {
      case 'cc-by': return "https://creativecommons.org/licenses/by/4.0/";
      case 'cc-by-nc': return "https://creativecommons.org/licenses/by-nc/4.0/";
      case 'cc0': return "https://creativecommons.org/publicdomain/zero/1.0/";
      case 'custom': return (customUrl && customUrl.trim()) ? customUrl : "https://creativecommons.org/licenses/by-sa/4.0/";
      case 'cc-by-sa':
      default: return "https://creativecommons.org/licenses/by-sa/4.0/";
    }
  }

  registerBlockType('mediageo/audio-geo', {
    title: 'AudioGEO',
    icon: 'format-audio',
    category: 'media',
    attributes: {
      url: { type: 'string', default: '' },
      title: { type: 'string', default: '' },
      description: { type: 'string', default: '' },
      author: { type: 'string', default: '' },
      duration: { type: 'string', default: '' },
      transcript: { type: 'string', default: '' },
      licenseType: { type: 'string', default: 'cc-by-sa' },
      licenseCustom: { type: 'string', default: '' }
    },

    edit: function(props) {
      var attrs = props.attributes || {};
      var set = props.setAttributes;
      var blockProps = useBlockProps();

      var licenseOptions = [
        { label: 'CC BY-SA 4.0 (par défaut)', value: 'cc-by-sa' },
        { label: 'CC BY 4.0', value: 'cc-by' },
        { label: 'CC BY-NC 4.0', value: 'cc-by-nc' },
        { label: 'CC0 (domaine public)', value: 'cc0' },
        { label: 'Autre licence (URL)', value: 'custom' }
      ];

      return createElement( Fragment, null,
        createElement( 'div', blockProps,
          createElement( TextControl, { label: 'URL du fichier audio (ou embed)', value: attrs.url, onChange: function(v){ set({ url: v }); } } ),
          createElement( TextControl, { label: 'Titre', value: attrs.title, onChange: function(v){ set({ title: v }); } } ),
          createElement( TextControl, { label: 'Description (pour IA)', value: attrs.description, onChange: function(v){ set({ description: v }); } } ),
          createElement( TextControl, { label: 'Auteur', value: attrs.author, onChange: function(v){ set({ author: v }); } } ),
          createElement( TextControl, { label: 'Durée (PT#M#S)', value: attrs.duration, onChange: function(v){ set({ duration: v }); } } ),
          createElement( TextControl, { label: 'Transcription (optionnelle)', value: attrs.transcript, onChange: function(v){ set({ transcript: v }); } } ),

          createElement( InspectorControls, null,
            createElement( PanelBody, { title: 'Licence / crédits', initialOpen: false },
              createElement( SelectControl, {
                label: 'Licence',
                value: attrs.licenseType,
                options: licenseOptions,
                onChange: function(v){ set({ licenseType: v }); },
                __next40pxDefaultSize: true,
                __nextHasNoMarginBottom: true
              }),
              attrs.licenseType === 'custom' && createElement( TextControl, {
                label: 'URL licence personnalisée',
                value: attrs.licenseCustom,
                onChange: function(v){ set({ licenseCustom: v }); },
                placeholder: 'https://...'
              })
            )
          )
        )
      );
    },

    save: function(props) {
      var attrs = props.attributes || {};
      var licenseFinal = resolveLicense(attrs.licenseType, attrs.licenseCustom);

      var schema = {
        "@context":"https://schema.org",
        "@type":"AudioObject",
        "name": attrs.title || undefined,
        "description": attrs.description || undefined,
        "contentUrl": attrs.url || undefined,
        "duration": attrs.duration || undefined,
        "author": attrs.author ? {"@type":"Person","name": attrs.author} : undefined,
        "license": licenseFinal
      };

      return createElement('figure', Object.assign({ className: 'geo-media geo-audio' }, useBlockProps.save()),
        attrs.url ? createElement('audio', { controls: true, src: attrs.url }) : null,
        attrs.title ? createElement('figcaption', null, attrs.title) : null,
        attrs.transcript ? createElement('div', { className: 'transcript' }, createElement('pre', null, attrs.transcript)) : null,
        createElement('script', { type: 'application/ld+json' }, JSON.stringify(schema, null, 2))
      );
    }
  });

} )();
