# Plugin GEO Entities Core

Plugin WordPress pour gérer proprement les entités Schema.org et optimiser la visibilité dans les moteurs IA (ChatGPT, Perplexity, Bing Copilot).

## 🎯 Objectif

Ce plugin génère automatiquement les entités Schema.org nécessaires pour :
- Améliorer le référencement (SEO)
- Optimiser la visibilité dans les moteurs IA (GEO - Generative Engine Optimization)
- Permettre aux IA de citer votre site comme source fiable

## 📦 Installation

1. Télécharger tous les fichiers dans `/wp-content/plugins/geo-entities/`
2. Activer le plugin dans WordPress
3. Aller dans **GEO Audit** dans le menu admin

## 🗂️ Structure des fichiers

```
geo-entities/
├── geo-entities.php           # Fichier principal
├── includes/
│   ├── entity-id.php          # Génération des @id uniques
│   ├── entity-registry.php    # Registre global des entités (CORRIGÉ)
│   ├── entity-audit.php       # Audit de cohérence (AMÉLIORÉ)
│   ├── admin-audit-page.php   # Interface admin (AMÉLIORÉE)
│   ├── schema-organization.php # Entité Organization (AMÉLIORÉE)
│   └── schema-person.php      # Entités Person (AMÉLIORÉE)
└── README.md                  # Ce fichier
```

## 🔧 Corrections apportées

### 1. `entity-registry.php` - CRITIQUE ⚠️
**Problème :** Variable `static` locale qui se réinitialisait à chaque appel
**Solution :** Utilisation d'une variable globale `$geo_entities_registry`

### 2. `entity-audit.php`
**Améliorations :**
- Forcer l'exécution de `wp_head` pour charger les entités
- Vérifications plus complètes (logo, description, worksFor)
- Messages d'erreur plus clairs
- Détection des doublons de @id
- Validation du format des @id

### 3. `admin-audit-page.php`
**Améliorations :**
- Interface plus lisible avec notices colorées
- Tableau détaillé des entités
- Affichage du JSON-LD généré
- Statistiques par type d'entité
- Recommandations GEO

### 4. `schema-organization.php`
**Améliorations :**
- Support du logo (customizer)
- Liens sociaux (Facebook, Twitter, LinkedIn, etc.)
- Email et téléphone de contact
- Adresse PostalAddress
- JSON-LD indenté pour debugging

### 5. `schema-person.php`
**Améliorations :**
- Lien `worksFor` vers l'Organization
- Avatar de l'auteur
- Description/Bio
- Liens sociaux de l'auteur
- Champs personnalisés dans le profil utilisateur

## 🚀 Utilisation

### Accéder à l'audit

1. Aller dans **WordPress Admin > GEO Audit**
2. La page affiche :
   - ✅ Nombre d'entités détectées
   - ❌ Erreurs critiques à corriger
   - ⚠️ Avertissements pour améliorer le GEO
   - 📊 Statistiques par type
   - 🔎 Détail de chaque entité
   - 📄 JSON-LD généré

### Configurer l'Organization

Ajoutez ces options dans votre thème ou via un plugin d'options :

```php
// Dans functions.php ou via une page d'options
update_option('geo_social_facebook', 'https://facebook.com/oceanail');
update_option('geo_social_twitter', 'https://twitter.com/oceansail');
update_option('geo_social_linkedin', 'https://linkedin.com/company/oceansail');
update_option('geo_social_instagram', 'https://instagram.com/oceansail');

update_option('geo_contact_email', 'contact@oceansail.fr');
update_option('geo_contact_phone', '+33491123456');

update_option('geo_address_street', 'Quai des Belges');
update_option('geo_address_city', 'Marseille');
update_option('geo_address_postal', '13001');
update_option('geo_address_country', 'FR');
```

### Configurer les auteurs (Person)

1. Aller dans **Utilisateurs > Votre profil**
2. Remplir les champs **Réseaux Sociaux** (ajoutés par le plugin)
3. Renseigner la **Biographie** pour la propriété `description`

## 🧪 Tester le JSON-LD

### Méthode 1 : Dans le code source
1. Afficher une page de votre site
2. Voir le code source (Ctrl+U)
3. Chercher `<script type="application/ld+json">`

### Méthode 2 : Validateurs en ligne
- [Schema.org Validator](https://validator.schema.org/)
- [Google Rich Results Test](https://search.google.com/test/rich-results)

### Méthode 3 : Depuis l'audit
Le JSON-LD complet est affiché dans **GEO Audit**

## 📋 Checklist GEO

### Organization (Obligatoire)
- [x] @id unique
- [x] Nom du site
- [x] URL du site
- [ ] Logo (via Apparence > Personnaliser > Identité du site)
- [ ] Description
- [ ] Liens sociaux
- [ ] Email de contact
- [ ] Téléphone
- [ ] Adresse PostalAddress (si local)

### Person (Pour chaque auteur)
- [x] @id unique
- [x] Nom de l'auteur
- [x] URL de la page auteur
- [x] Lien `worksFor` vers Organization
- [ ] Avatar/Photo
- [ ] Description/Bio
- [ ] Liens sociaux

### Article (Automatique)
- [x] Titre
- [x] Date de publication
- [x] Date de modification
- [x] Auteur (Person)
- [x] Image à la une
- [ ] Organization comme publisher

## 🎯 Résultats attendus

### Avant
```
❌ Aucune entité Organization détectée
❌ Les personnes ne sont pas reliées à une Organization
⚠️ Pas de logo, pas de description
```

### Après configuration
```
✅ 1 Organization valide
✅ 3 Person reliées à l'Organization
✅ Tous les @id sont uniques et bien formés
✅ Le graphe d'entités est propre et optimisé pour le GEO
```

## 🔄 Prochaines améliorations

- [ ] Page d'options pour configurer l'Organization sans code
- [ ] Support de LocalBusiness pour les entreprises locales
- [ ] Support de FAQPage pour les pages FAQ
- [ ] Support de Article/BlogPosting avec plus de détails
- [ ] Export du graphe d'entités en format llms.json
- [ ] Génération automatique du fichier llms.txt

## 🐛 Debugging

### L'audit affiche "0 entités"

**Cause :** Les hooks `wp_head` ne sont pas exécutés dans l'admin

**Solution appliquée :** L'audit force maintenant l'exécution de `wp_head` avec `do_action('wp_head')`

### Les entités ne s'affichent pas

1. Vérifier que le plugin est activé
2. Vérifier que le thème appelle `wp_head()` dans `header.php`
3. Vider le cache si vous utilisez un plugin de cache
4. Désactiver les plugins de SEO (Yoast, Rank Math) temporairement pour tester

### Les @id sont en double

Cela ne devrait plus arriver avec la correction du registre. Si ça persiste :
1. Vérifier qu'aucun autre plugin ne génère les mêmes entités
2. Désactiver les plugins de SEO qui génèrent du JSON-LD

## 📚 Ressources

- [Schema.org Organization](https://schema.org/Organization)
- [Schema.org Person](https://schema.org/Person)
- [Google Search Central - Structured Data](https://developers.google.com/search/docs/appearance/structured-data/intro-structured-data)
- [GEO (Generative Engine Optimization)](https://www.semrush.com/blog/generative-engine-optimization/)

## 📝 Licence

GPL v2 or later

## 👨‍💻 Auteur

Plugin créé pour optimiser la visibilité dans les moteurs IA (ChatGPT, Perplexity, Bing Copilot).