<?php
/**
 * entity-registry.php - VERSION CORRIGÉE
 * Stocke et retourne les entités déclarées par le plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

// Variable globale pour stocker les entités
global $geo_entities_registry;
$geo_entities_registry = [];

/**
 * Enregistre une entité dans le registre global
 */
function geo_register_entity(array $entity): void {
    global $geo_entities_registry;

    if (empty($entity['@id'])) {
        return;
    }

    $geo_entities_registry[$entity['@id']] = $entity;
}

/**
 * Récupère toutes les entités enregistrées
 */
function geo_get_entities(): array {
    global $geo_entities_registry;
    return $geo_entities_registry ?? [];
}

/**
 * Récupère une entité spécifique par son @id
 */
function geo_get_entity(string $id): ?array {
    global $geo_entities_registry;
    return $geo_entities_registry[$id] ?? null;
}

/**
 * Compte le nombre d'entités enregistrées
 */
function geo_count_entities(): int {
    global $geo_entities_registry;
    return count($geo_entities_registry ?? []);
}

/**
 * Réinitialise le registre (utile pour les tests)
 */
function geo_reset_entities(): void {
    global $geo_entities_registry;
    $geo_entities_registry = [];
}