<?php

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Génère un @id unique, stable et typé pour une entité Schema.org
 *
 * @param string $type  Type d'entité (organization, person, service…)
 * @param string $slug  Identifiant lisible optionnel
 * @return string
 */
function geo_entity_id(string $type, string $slug = ''): string {

    $base = trailingslashit(home_url());

    $type = sanitize_key($type);

    $id = $type;
    if (!empty($slug)) {
        $id .= '-' . sanitize_title($slug);
    }

    return $base . '#' . $id;
}
