<?php
/**
 * Plugin Name: GEO Entities Core
 * Description: Gestion propre des entités Schema.org (SEO / GEO / IA-ready)
 * Version: 0.2.0
 * Author: Erwan Tanguy - Ticoët
 * Author URI: https://www.ticoet.fr/
 */

if (!defined('ABSPATH')) {
    exit;
}

define('GEO_ENTITIES_PATH', plugin_dir_path(__FILE__));
define('GEO_ENTITIES_URL', plugin_dir_url(__FILE__));

require_once GEO_ENTITIES_PATH . 'includes/entity-id.php';
require_once GEO_ENTITIES_PATH . 'includes/entity-registry.php';
require_once GEO_ENTITIES_PATH . 'includes/entity-audit.php';
require_once GEO_ENTITIES_PATH . 'includes/admin-audit-page.php';
require_once GEO_ENTITIES_PATH . 'includes/schema-organization.php';
require_once GEO_ENTITIES_PATH . 'includes/schema-person.php';
require_once GEO_ENTITIES_PATH . 'includes/llms-generator.php';

/**
 * Charge le CSS admin
 */
add_action('admin_enqueue_scripts', function() {
    wp_enqueue_style(
        'geo-entities-admin',
        GEO_ENTITIES_URL . 'assets/style.css',
        [],
        '0.2.0' // Utilisez le numéro de version du plugin
    );
});