# GEO Entities + EAS Bridge

Plugin pont pour faire communiquer **GEO Entities Core** et **Entity & Authority Signals**.

## 🎯 Problème résolu

### Sans le bridge

```
Plugin GEO Entities      Plugin Entity Authority Signals
     |                              |
     |                              |
  Génère                         Génère
  JSON-LD                        JSON-LD
     |                              |
     v                              v
 Registre GEO              Directement dans HTML
 (isolé)                   (non détecté par GEO)
```

**Résultat :** L'audit GEO Entities affiche "0 entités" même si Entity Authority Signals en a créé plusieurs.

### Avec le bridge

```
Plugin GEO Entities      BRIDGE      Plugin Entity Authority Signals
     |                      |                    |
     |                      |                    |
  Génère   <---------------+---------------   Génère
  JSON-LD      Copie dans registre GEO        JSON-LD
     |                      |                    |
     v                      v                    v
 Registre GEO unifié    (détection)         Directement dans HTML
```

**Résultat :** L'audit GEO Entities détecte TOUTES les entités, peu importe leur origine.

## 📥 Installation

### Prérequis

Avoir installé et activé :
1. ✅ **GEO Entities Core**
2. ✅ **Entity & Authority Signals V2**

### Installation du bridge

1. Créer le dossier `/wp-content/plugins/geo-eas-bridge/`
2. Y placer le fichier `geo-eas-bridge.php`
3. Activer le plugin dans WordPress

## 🧪 Test

### Avant le bridge

```
WordPress Admin > GEO Audit
───────────────────────────────
❌ Nombre d'entités : 0
❌ Aucune entité détectée
```

### Après le bridge

```
WordPress Admin > GEO Audit
───────────────────────────────
✅ Nombre total d'entités : 2

Provenance des entités :
• Entity Authority Signals : 2 entité(s)

Répartition par type :
• Organization : 1
• Person : 1

✅ 1 Organization valide : "IA Académie"
✅ 1 Person reliée à l'Organization
✅ La personne "Anthony Cocherie" est reliée via worksFor
```

## 🔍 Comment ça marche

### 1. Le bridge s'exécute tôt

```php
add_action('wp_head', function () {
    // Priorité 5 = avant GEO Entities (priorité 20+)
}, 5);
```

### 2. Il récupère les entités EAS

```php
$entities = get_posts([
    'post_type' => 'entity',
    'posts_per_page' => -1,
]);
```

### 3. Il les enregistre dans le registre GEO

```php
foreach ($entities as $entity) {
    $schema = eas_build_entity_schema_for_geo($entity);
    geo_register_entity($schema); // ← Enregistre dans GEO
}
```

### 4. L'audit les détecte

Quand GEO Entities lance son audit, il trouve les entités dans son registre, peu importe leur source.

## ✨ Fonctionnalités

### Détection automatique

Le bridge détecte automatiquement :
- Les entités Organization
- Les entités Person
- Les relations worksFor et memberOf
- Les propriétés Schema.org (image, sameAs, adresse, etc.)

### Affichage de la source

Dans l'audit, vous voyez la provenance :

```
Provenance des entités :
• GEO Entities natif : 1 entité(s)
• Entity Authority Signals : 2 entité(s)
```

### Notice admin

Un message s'affiche dans l'audit pour confirmer que le bridge fonctionne :

```
🔗 Bridge GEO Entities ↔ Entity Authority Signals actif
2 entité(s) d'Entity Authority Signals sont maintenant détectées par GEO Entities.
```

## 🛠️ Compatibilité

### Plugins requis

| Plugin | Version min. | Statut |
|--------|-------------|---------|
| GEO Entities Core | 0.1.0+ | ✅ Requis |
| Entity & Authority Signals | 2.0.0+ | ✅ Requis |

### Plugins compatibles

- ✅ Yoast SEO
- ✅ Rank Math
- ✅ All in One SEO
- ✅ BaseTheme WordPress

## 📊 Exemple de sortie

### Votre code JSON-LD (Entity Authority Signals)

```json
{
  "@context": "https://schema.org",
  "@graph": [
    {
      "@type": "Organization",
      "@id": "https://ia-academie.org/#entity-3373",
      "name": "IA Académie",
      "url": "https://ia-academie.org/",
      "logo": "..."
    },
    {
      "@type": "Person",
      "@id": "https://ia-academie.org/#entity-3371",
      "name": "Anthony Cocherie",
      "worksFor": {
        "@type": "Organization",
        "@id": "https://ia-academie.org/#entity-3373"
      }
    }
  ]
}
```

### Ce que voit l'audit GEO Entities

```
✅ 2 entités détectées
✅ 1 Organization : "IA Académie"
✅ 1 Person : "Anthony Cocherie"
✅ Relation worksFor correcte
✅ Logo présent
✅ @id uniques et bien formés
```

## 🐛 Dépannage

### Le bridge ne détecte rien

**Vérifier :**
1. Les deux plugins sont bien activés
2. Des entités sont publiées dans Entity Authority Signals
3. Vider le cache WordPress

**Solution :**
```bash
# Dans l'admin WordPress
1. Désactiver le bridge
2. Réactiver le bridge
3. Rafraîchir la page GEO Audit
```

### Les entités apparaissent en double

**Cause :** Vous avez créé les mêmes entités dans les deux plugins

**Solution :** 
- Supprimer les doublons d'un des deux plugins
- OU utiliser uniquement Entity Authority Signals pour créer les entités

### Conflit de @id

**Cause :** GEO Entities et EAS utilisent des formats de @id différents

**Résultat :** Pas de problème ! Le bridge respecte le format EAS (`#entity-XXX`)

## 💡 Recommandations

### Workflow recommandé

1. **Utiliser Entity & Authority Signals** pour créer toutes vos entités
   - Interface complète
   - Relations worksFor/memberOf
   - Meta boxes riches

2. **Utiliser GEO Entities** uniquement pour l'audit
   - Vérification de cohérence
   - Détection d'erreurs
   - Recommandations GEO

3. **Le bridge** fait le lien automatiquement
   - Aucune configuration nécessaire
   - Détection automatique
   - Pas de doublon

### Ne PAS faire

❌ Créer les mêmes entités dans les deux plugins  
❌ Désactiver Entity Authority Signals si le bridge est actif  
❌ Modifier manuellement le registre GEO  

## 🔮 Évolutions futures

- [ ] Détection bidirectionnelle (EAS → GEO et GEO → EAS)
- [ ] Synchronisation des modifications
- [ ] Interface unifiée
- [ ] Export/Import entre les deux plugins

## 📝 Licence

GPL v2 or later

## 👨‍💻 Support

Compatible avec :
- WordPress 5.8+
- PHP 7.4+
- GEO Entities Core 0.1.0+
- Entity & Authority Signals 2.0.0+

---

**Version :** 1.0.0  
**Dernière mise à jour :** Janvier 2025