<?php
/**
 * CPT Entity - Custom Post Type pour les entités
 */

if (!defined('ABSPATH')) {
    exit;
}

add_action('init', function () {

    register_post_type('entity', [
        'labels' => [
            'name'               => 'Entités',
            'singular_name'      => 'Entité',
            'add_new'            => 'Ajouter une entité',
            'add_new_item'       => 'Ajouter une nouvelle entité',
            'edit_item'          => 'Modifier l\'entité',
            'new_item'           => 'Nouvelle entité',
            'view_item'          => 'Voir l\'entité',
            'search_items'       => 'Rechercher des entités',
            'not_found'          => 'Aucune entité trouvée',
            'not_found_in_trash' => 'Aucune entité dans la corbeille',
            'all_items'          => 'Toutes les entités',
        ],
        'public'              => false,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'menu_icon'           => 'dashicons-networking',
        'menu_position'       => 20,
        'supports'            => ['title', 'editor', 'thumbnail'],
        'taxonomies'          => ['entity_type'], // CRUCIAL: Rend la taxonomie visible
        'has_archive'         => false,
        'rewrite'             => false,
        'capability_type'     => 'post',
        'show_in_rest'        => true,
    ]);

});

/**
 * Ajoute des colonnes personnalisées dans la liste des entités
 */
add_filter('manage_entity_posts_columns', function ($columns) {
    $new_columns = [];
    $new_columns['cb'] = $columns['cb'];
    $new_columns['title'] = $columns['title'];
    $new_columns['entity_type'] = 'Type';
    $new_columns['canonical'] = 'Nom canonique';
    $new_columns['linked_posts'] = 'Contenus liés';
    $new_columns['date'] = $columns['date'];
    return $new_columns;
});

/**
 * Remplit les colonnes personnalisées
 */
add_action('manage_entity_posts_custom_column', function ($column, $post_id) {
    switch ($column) {
        case 'entity_type':
            $types = wp_get_post_terms($post_id, 'entity_type');
            if ($types && !is_wp_error($types)) {
                $names = array_map(function($type) {
                    return $type->name;
                }, $types);
                echo esc_html(implode(', ', $names));
            } else {
                echo '—';
            }
            break;
            
        case 'canonical':
            $canonical = get_post_meta($post_id, '_entity_canonical', true);
            echo $canonical ? esc_html($canonical) : '—';
            break;
            
        case 'linked_posts':
            $count = get_post_meta($post_id, '_linked_posts_count', true);
            echo $count ? esc_html($count) : '0';
            break;
    }
}, 10, 2);